<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'wp_enqueue_scripts', 'enqueue_divi_child_styles' );
function enqueue_divi_child_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'futura-font', 'https://fonts.googleapis.com/css2?family=Futura&display=swap', array(), null );
}

add_shortcode('gll_rolodex', 'display_gll_rolodex');
function display_gll_rolodex() {
    $db = new mysqli('localhost', 'qistwo_newuser', 'March@1703', 'qistwo_glo_dom');
    if ($db->connect_error) {
        return 'Connection failed: ' . $db->connect_error;
    }
    $listings = $db->query("SELECT * FROM gll_listings WHERE state_region = 'HI' ORDER BY business_name LIMIT 50");
    $output = '<div class="gll-rolodex">';
    $output .= '<div class="gll-dial-bar"><span class="gll-dial-up">▲</span><span class="gll-dial-stop">■</span><span class="gll-dial-down">▼</span></div>';
    if ($listings && $listings->num_rows > 0) {
        while ($listing = $listings->fetch_object()) {
            $output .= '<div class="gll-rolodex-card">';
            $output .= '<div class="gll-rolodex-top" style="background: url(\'https://golikelocals.com/images/GLLdexCard.png\') no-repeat center; background-size: 600px 400px;">';
            $output .= '<div class="gll-snapshots">';
            $output .= '<img src="https://golikelocals.com/images/HI/landscape_2-HI.jpg" class="gll-snapshot gll-snapshot-horiz">';
            $output .= '<img src="https://golikelocals.com/images/HI/landscape_4-HI.jpg" class="gll-snapshot gll-snapshot-horiz">';
            $output .= '<img src="https://golikelocals.com/images/HI/landscape_1-HI.jpg" class="gll-snapshot gll-snapshot-vert">';
            $output .= '</div>';
            $output .= '<div class="gll-map" id="map-' . esc_attr($listing->id ?? uniqid()) . '" data-address="' . esc_attr($listing->address . ', ' . $listing->city . ', HI ' . $listing->zip) . '"></div>';
            $output .= '</div>';
            $output .= '<div class="gll-rolodex-bottom" style="background: url(\'https://golikelocals.com/images/GLLdexCard.png\') no-repeat center; background-size: 600px 400px;">';
            $output .= '<div class="gll-card">';
            $output .= '<div class="gll-card-inner">';
            $output .= '<div class="gll-card-front">';
            $output .= '<h3>' . esc_html($listing->business_name) . '</h3>';
            if ($listing->logo) {
                $logo_path = '/States/logos/' . esc_html($listing->logo);
                $full_url = 'https://golikelocals.com' . $logo_path;
                $output .= '<img src="' . esc_url($full_url) . '" alt="' . esc_html($listing->business_name) . ' Logo" class="gll-logo">';
            }
            $output .= '<p class="gll-category">' . esc_html($listing->category) . '</p>';
            $output .= '</div>';
            $output .= '<div class="gll-card-back">';
            $output .= '<p><strong>Address:</strong> ' . esc_html($listing->address) . '</p>';
            $output .= '<p><strong>City:</strong> ' . esc_html($listing->city) . ', HI ' . esc_html($listing->zip) . '</p>';
            $output .= '<p><strong>Phone:</strong> <a href="tel:' . esc_attr($listing->phone) . '">' . esc_html($listing->phone) . '</a></p>';
            $output .= '<p><strong>Website:</strong> <a href="' . esc_url($listing->website) . '" target="_blank">' . esc_html($listing->website) . '</a></p>';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
        }
    } else {
        $output .= '<p>No listings found.</p>';
    }
    $output .= '<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCU-qb8neW6TUwF3xsunI5y5XaSODcEf9I&callback=initMaps" async defer></script>';
    $output .= '<script>
    function initMaps() {
        var maps = document.querySelectorAll(".gll-map");
        maps.forEach(function(map) {
            var address = map.getAttribute("data-address");
            var geocoder = new google.maps.Geocoder();
            geocoder.geocode({"address": address}, function(results, status) {
                if (status === "OK") {
                    var mapOptions = {
                        center: results[0].geometry.location,
                        zoom: 14,
                        styles: [
                            {"featureType": "all", "elementType": "all", "stylers": [{"saturation": -100}, {"lightness": 20}, {"gamma": 1.5}]},
                            {"featureType": "road", "elementType": "geometry", "stylers": [{"color": "#d9c7a2"}]},
                            {"featureType": "water", "elementType": "geometry", "stylers": [{"color": "#b5d8e6"}]}
                        ]
                    };
                    new google.maps.Map(map, mapOptions);
                }
            });
        });
    }
    document.addEventListener("DOMContentLoaded", function() {
        var rolodexCards = document.querySelectorAll(".gll-rolodex-card");
        var businessCards = document.querySelectorAll(".gll-card");
        var currentIndex = 0;
        businessCards.forEach(function(card) {
            card.addEventListener("click", function(e) {
                e.stopPropagation();
                var inner = this.querySelector(".gll-card-inner");
                inner.style.transform = inner.style.transform === "rotateY(180deg)" ? "rotateY(0deg)" : "rotateY(180deg)";
            });
        });
        var dialUp = document.querySelector(".gll-dial-up");
        var dialDown = document.querySelector(".gll-dial-down");
        dialUp.addEventListener("click", function() {
            currentIndex = (currentIndex - 1 + rolodexCards.length) % rolodexCards.length;
            updateRolodex();
        });
        dialDown.addEventListener("click", function() {
            currentIndex = (currentIndex + 1) % rolodexCards.length;
            updateRolodex();
        });
        function updateRolodex() {
            rolodexCards.forEach(function(card, index) {
                card.style.display = index === currentIndex ? "block" : "none";
                if (index === currentIndex) {
                    var snapshots = card.querySelectorAll(".gll-snapshot");
                    var horizontals = [2, 4, 6];
                    var verticals = [1, 3, 5, 7, 9, 11];
                    snapshots[0].src = "https://golikelocals.com/images/HI/landscape_" + horizontals[Math.floor(Math.random() * 3)] + "-HI.jpg";
                    snapshots[1].src = "https://golikelocals.com/images/HI/landscape_" + horizontals[Math.floor(Math.random() * 3)] + "-HI.jpg";
                    snapshots[2].src = "https://golikelocals.com/images/HI/landscape_" + verticals[Math.floor(Math.random() * 6)] + "-HI.jpg";
                }
            });
        }
        updateRolodex();
    });
</script>';
    $output .= '</div>';
    $db->close();
    return $output;
}