<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'wp_enqueue_scripts', 'enqueue_divi_child_styles' );
function enqueue_divi_child_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'futura-font', 'https://fonts.googleapis.com/css2?family=Futura&display=swap', array(), null );
}

add_shortcode('gll_rolodex', 'display_gll_rolodex');
function display_gll_rolodex() {
    $db = new mysqli('localhost', 'qistwo_newuser', 'March@1703', 'qistwo_glo_dom');
    if ($db->connect_error) {
        return 'Connection failed: ' . $db->connect_error;
    }
    $listings = $db->query("SELECT * FROM gll_listings WHERE state_region = 'HI' ORDER BY business_name LIMIT 50");
    $output = '<div class="gll-rolodex">';
   $output .= '<div class="gll-dial-bar"><span class="gll-dial-up">▲</span><span class="gll-dial-stop">■</span><span class="gll-dial-down">▼</span></div>';
    if ($listings && $listings->num_rows > 0) {
        while ($listing = $listings->fetch_object()) {
            $output .= '<div class="gll-card">';
            $output .= '<div class="gll-card-inner">';
            $output .= '<div class="gll-card-front">';
            $output .= '<h3>' . esc_html($listing->business_name) . '</h3>';
            if ($listing->logo) {
                $logo_path = '/States/logos/' . esc_html($listing->logo);
                $full_url = 'https://golikelocals.com' . $logo_path;
                $output .= '<img src="' . esc_url($full_url) . '" alt="' . esc_html($listing->business_name) . ' Logo" class="gll-logo">';
            }
            $output .= '<p class="gll-category">' . esc_html($listing->category) . '</p>';
            $output .= '</div>';
            $output .= '<div class="gll-card-back">';
            $output .= '<p><strong>Address:</strong> ' . esc_html($listing->address) . '</p>';
            $output .= '<p><strong>City:</strong> ' . esc_html($listing->city) . ', HI ' . esc_html($listing->zip) . '</p>';
            $output .= '<p><strong>Phone:</strong> ' . esc_html($listing->phone) . '</p>';
            $output .= '<p><strong>Website:</strong> <a href="' . esc_url($listing->website) . '" target="_blank">' . esc_html($listing->website) . '</a></p>';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
        }
    } else {
        $output = '<p>No listings found.</p>';
    }
    $output .= '<script>
        document.addEventListener("DOMContentLoaded", function() {
            var cards = document.querySelectorAll(".gll-card");
            var currentIndex = 0;
            cards.forEach(function(card) {
                card.addEventListener("click", function() {
                    var inner = this.querySelector(".gll-card-inner");
                    inner.style.transform = inner.style.transform === "rotateY(180deg)" ? "rotateY(0deg)" : "rotateY(180deg)";
                });
            });
           var dialUp = document.querySelector(".gll-dial-up");
var dialDown = document.querySelector(".gll-dial-down");
var dialStop = document.querySelector(".gll-dial-stop");
dialUp.addEventListener("click", function() {
    currentIndex = (currentIndex - 1 + cards.length) % cards.length; // Go up (back)
    updateCards();
});
dialDown.addEventListener("click", function() {
    currentIndex = (currentIndex + 1) % cards.length; // Go down (forward)
    updateCards();
});
function updateCards() {
    cards.forEach(function(card, index) {
        var zOffset = (index - currentIndex) * -40;
        card.style.transform = `translate(-50%, -50%) translateZ(${zOffset}px) rotate(${(index - currentIndex) * 2}deg)`;
        card.style.zIndex = 10 - Math.abs(index - currentIndex);
        card.style.opacity = 1 - (Math.abs(index - currentIndex) * 0.05);
    });
}
        });
    </script>';
    $output .= '</div>';
    $db->close();
    return $output;
}